/*
	FILE:	bool.c

	DESC:

		Code to make handling T/F values easier.


	REV:	001, 2011/05/23: initial version

*/

#include <debugging.h>
#include <bool.h>
#include <string.h>
#include <unistd.h>




TRUE_TOKEN_TABLE;
FALSE_TOKEN_TABLE;


/*
	FUNC: str_is_true()
			str_is_false()

	DESC:

		Returns 1 if the string passed to the function represents a value of 'true'.

		Possibly this should use a str_ing.

*/

int	str_is_true(char *s)
{
	char *p = true_token_table[0];


	if(!s)
		die("NULL arg.");

	
	while(p) {
		if(strcmp(s, p++) == 0)
			return(1);
	}

	return(0);
}



int	str_is_false(char *s)
{
	char *p = false_token_table[0];


	if(!s)
		die("NULL arg.");

	
	while(p) {
		if(strcmp(s, p++) == 0)
			return(1);
	}

	return(0);
}


