#!/bin/bash
#Copyright (c) 2014 Texas Instruments
# Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


# script to programme SD card following instructions from 
#  https://eewiki.net/display/linuxonarm/BeagleBoard-X15#BeagleBoard-X15-Debian9

if [ $# -eq 1 ]; then

   echo "will use drive /dev/$1"
   DEVICEDRIVENAME=$1
   DISK=/dev/$DEVICEDRIVENAME

   NUM_OF_DRIVES=`df | grep -c $DISK`

   # This if statement will determine if we have a mounted sdX or mmcblkX device.
   # If it is mmcblkX, then we need to set an extra char in the partition names, 'p',
   # to account for /dev/mmcblkXpY labled partitions.
   if [[ ${DEVICEDRIVENAME} =~ ^sd. ]]; then
	echo "$DRIVE is an sdx device"
	P=''
   else
	echo "$DRIVE is an mmcblkx device"
	P='p'
   fi

   if [ "$NUM_OF_DRIVES" != "0" ]; then
        echo "Unmounting the $DEVICEDRIVENAME drives"
        for ((c=1; c<="$NUM_OF_DRIVES"; c++ ))
        do
                unmounted=`df | grep '\<'$DEVICEDRIVENAME$P$c'\>' | awk '{print $1}'`
                if [ -n "$unmounted" ]
                then
                     echo " unmounted ${DISK}$P$c"
                     sudo umount -f ${DISK}$P$c
                fi

        done
   fi

   # Extract build package
   cd mmc-package
   tar -xf mmc-package.tar || exit
   cd ..
    
   # erase drive
   sudo dd if=/dev/zero of=${DISK} bs=1M count=10
   # and write MLO & uboot
   sudo dd if=mmc-package/MLO of=${DISK} count=2 seek=1 bs=128k
   sudo dd if=mmc-package/u-boot.img of=${DISK} count=4 seek=1 bs=384k

   # now create partition
   sudo sfdisk ${DISK} <<-__EOF__
4M,,L,*
__EOF__

 
   DISK_IN_USE=${DISK}${P}1
   echo "now try to format ${DISK_IN_USE}"

 
   sleep 2
   # and format it
   sudo mkfs.ext4 ${DISK}${P}1 -L rootfs
   sync
   sync


   #mount rootfs
   sudo mkdir -p rootfs-sd
   echo "sudo mount -t ext4 ${DISK_IN_USE} rootfs"
   sudo mount -t ext4 ${DISK_IN_USE} rootfs-sd || exit
   echo "successfully mounted"


   # Now extract rootfs
   cd rootfs-sd
   sudo tar -xf ../mmc-package/tar-rootfs.tar
   cd ..

   sync
   echo "sudo umount -f ${DISK_IN_USE} || exit"
   sudo umount -f ${DISK_IN_USE} || exit
   sudo rm -r rootfs-sd
   echo "successfully unmounted"

 
else

   echo "must take argument of SD card device after /dev/, so /dev/sdd is sdd" 
fi 


