/*
    Domain info C stubs for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <unistd.h>

#include <xenctrl.h>
#include <xen/domctl.h>

#include <caml/mlvalues.h>
#include <caml/callback.h>
#include <caml/memory.h>
#include <caml/alloc.h>

/* Initialise a domain's info */
value init_dominfo_c (value dummy_v)
{
	CAMLparam1 (dummy_v);

	value dominfo_v = alloc (Abstract_tag, 1);
	Field (dominfo_v, 0) = (value) malloc (sizeof(xc_dominfo_t));

	CAMLreturn (dominfo_v);
}

/* Return a domain's info */
value xc_domain_getinfo_c (value fd_v, value domid_v, value max_doms_v, value dominfo_v)
{
	CAMLparam4 (fd_v, domid_v, max_doms_v, dominfo_v);

	int fd = Int_val (fd_v);
	uint32_t domid = (uint32_t)(Int_val (domid_v));
	unsigned int max_doms = Int_val (max_doms_v);
	xc_dominfo_t *dominfo = (xc_dominfo_t *)(Field (dominfo_v, 0));

	CAMLreturn (Val_int (xc_domain_getinfo(fd, domid, max_doms, dominfo)));
}

/* Return a domain's crashed state */
value get_crashed_c (value dominfo_v)
{
	CAMLparam1 (dominfo_v);

	xc_dominfo_t *dominfo = (xc_dominfo_t *)(Field (dominfo_v, 0));

	CAMLreturn (caml_copy_int32(dominfo->crashed));
}

/* Return a domain's ID */
value get_domid_c (value dominfo_v)
{
	CAMLparam1 (dominfo_v);

	xc_dominfo_t *dominfo = (xc_dominfo_t *)(Field (dominfo_v, 0));

	CAMLreturn (caml_copy_int32(dominfo->domid));
}

/* Return a domain's dying state */
value get_dying_c (value dominfo_v)
{
	CAMLparam1 (dominfo_v);

	xc_dominfo_t *dominfo = (xc_dominfo_t *)(Field (dominfo_v, 0));

	CAMLreturn (caml_copy_int32(dominfo->dying));
}

/* Return a domain's shutdown state */
value get_shutdown_c (value dominfo_v)
{
	CAMLparam1 (dominfo_v);

	xc_dominfo_t *dominfo = (xc_dominfo_t *)(Field (dominfo_v, 0));

	CAMLreturn (caml_copy_int32(dominfo->shutdown));
}
