/**************************************************************************\
*//*! \file svh_null.c Null (dummy) semi-virtualised hardware functions

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*//*
\**************************************************************************/

#include <ci/driver/virtual/vnic.h>
#include <etherfabric/vi.h>
#include <etherfabric/tools.h>
#include "ef_vnic_bufs.h"

static
void ef_vnic_nullsvh_dtor(ef_vnic_svh *svh)
{
  /* Yawn */
}

static
int ef_vnic_nullsvh_ctor(ef_vnic_svh *svh, struct ef_msg_hw *hw_msg)
{
  return 0;
}

static
void ef_vnic_nullsvh_add_bufs(ef_vnic_svh *svh, struct ef_msg *msg)
{
  ci_fail(("This should never happen."));
}

static
enum ef_vnic_post_status ef_vnic_nullsvh_tx_post(ef_vnic_svh *svh,
                                             ef_vnic_pktbuff *pktbuff)
{
  /* Just force slow path */
  return EF_VNIC_STATUS_FAIL;
}

static
void ef_vnic_nullsvh_unpost_all(ef_vnic_svh *svh)
{
  ci_log("%s: FIXME", __FUNCTION__);
}


static
int  ef_vnic_nullsvh_poll(ef_vnic_svh *svh,
                      int rx_packets)
{
  /* The generic SVH layer has already polled the slow path, so nothing
  * to do. */
  return 0;
}

static
void ef_vnic_nullsvh_updated_mtu(ef_vnic_svh *svh)
{
  /* We never process any packets, so this is irrelevant. */
}

static
ci_boolean_t ef_vnic_nullsvh_check_interrupts(ef_vnic_svh *svh)
{
  /* Nothing to do: the SVH doesn't manage the interdomain IRQs and
  * there is no H/W */
  return CI_FALSE;
}

static
ci_boolean_t ef_vnic_nullsvh_enable_interrupts(ef_vnic_svh *svh)
{
  /* Nothing to do: the SVH doesn't manage the interdomain IRQs and
  * there is no H/W */
  return CI_TRUE;
}

static
void ef_vnic_nullsvh_disable_interrupts(ef_vnic_svh *svh)
{
  /* Mmmm... donuts */
}


ef_vnic_svh_functions ef_vnic_svh_null = {
  &ef_vnic_nullsvh_ctor,
  &ef_vnic_nullsvh_dtor,
  &ef_vnic_nullsvh_add_bufs,
  &ef_vnic_nullsvh_tx_post,
  &ef_vnic_nullsvh_unpost_all,
  &ef_vnic_nullsvh_poll,
  &ef_vnic_nullsvh_updated_mtu,
  &ef_vnic_nullsvh_check_interrupts,
  &ef_vnic_nullsvh_enable_interrupts,
  &ef_vnic_nullsvh_disable_interrupts
};
