/**************************************************************************\
*//*! \file ef_mcast.h Multicast handling for backend driver

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 *//*
\**************************************************************************/


/*! Initialise the multicast handling.
 * \return 0 on success
*/
extern int ef_mcast_init(void);

/*! Shut down the multicast handling and free memory. */
 extern void ef_mcast_shutdown(void);

/*! Add a backend to the subscription list for a specific multicast MAC.
 * Not reentrant (only called from message handler)
 * \param bend : a backend
 * \param mac : the MAC to subscribe to
 * \return 0 on success
*/
extern int ef_mcast_subscribe(struct ef_bend *bend, __u8 *mac);

/*! Remove a backend from the subscription list for a specific mcast MAC
 * Not reentrant (only called from message handler)
 * \param bend : a backend
 * \param mac : the MAC to subscribe to
 * \return 0 on success
 */
extern int ef_mcast_cancel_my_subscription(struct ef_bend *bend, __u8 *mac);


/*! Get an array of backends subscribed to a given MAC. This may as a side 
 * effect result in filter insertion if there is a single subscriber
 * \param mac : a multicast MAC address
 * \param ip_be : dest IP in network order (used for filter insertion)
 * \param port_be : dest port in network order (used for filter insertion)
 * \param num_bends : filled out with the number of backends returned.
*/
extern struct ef_bend **ef_mcast_process_pkt(__u8 *mac,
                                  struct ef_filter_spec *spec,
                                  int *num_bends);
