/**************************************************************************\
*//*! \file ef_misc_util.c Access to ci_log and ci_fail

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 *//*
\**************************************************************************/

#include "linux/kernel.h"
#include "etherfabric/vi.h"
/* Replacements for a few things referenced by the inlines we use. */

#define CI_LOG_PREFIX_DEFAULT "SETME:"

static const char *ci_log_prefix;

void ci_set_log_prefix(const char* prefix)
{
  if( !prefix ) {
    ci_log_prefix = CI_LOG_PREFIX_DEFAULT;
    return;
  }
  ci_log_prefix = prefix;
}

void ci_log(const char *fmt, ...)
{
  va_list args;
  printk(ci_log_prefix);
  va_start(args, fmt);
  vprintk(fmt, args);
  va_end(args);
  printk("\n");
}

void __ci_fail(const char* fmt, ...)
{
  va_list args;
  printk("%s FAIL!!!: ", ci_log_prefix);
  va_start(args, fmt);
  vprintk(fmt, args);
  va_end(args);
  printk("\n");
  BUG();
}
