/**************************************************************************\
*//*! \file ef_bend_vnic.h backend <-> frontend communication

Copyright 2006 Solarflare Communications Inc,
               9501 Jeronimo Road, Suite 250,
               Irvine, CA 92618, USA

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation, incorporated herein by reference.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 *//*
\**************************************************************************/

/*! \brief Send the start-of-day message that handshakes with the VNIC
 *  and tells it its MAC address.
 *
 * \param bend The back end driver data structure
 */
void ef_bend_vnic_hello(struct ef_bend * bend);

/*! \brief Process the message queue for a bend that has just
 * interrupted.
 * 
 * Demultiplexs an interrupt from the front end driver, taking
 * messages from the fifo and taking appropriate action.
 * 
 * \param bend The back end driver data structure
 */
void ef_bend_vnic_msghandler(struct ef_bend *bend);

/*! \brief Send a "there's a new local mac address" message 
 *
 * \param bend The back end driver data structure for the vnic to send
 * the message to 
 * \param mac Pointer to the new mac address
 */
void ef_bend_vnic_new_localmac(struct ef_bend *bend, const void *mac);

/*! \brief Send a "a mac address that was local has gone away" message 
 *
 * \param bend The back end driver data structure for the vnic to send
 * the message to 
 * \param mac Pointer to the old mac address
 */
void ef_bend_vnic_old_localmac(struct ef_bend *bend, const void *mac);
