import struct
import Register
import StringIO

class BaseElfPrstatus(object):
    def __init__(self, context=None):

        if context:
            self.context = context
        else:
            self.context = "\x00" * self.ctxt_size

        self.ctxtf = StringIO.StringIO(self.context)

    def __str__(self):
        return self.ctxtf.getvalue()

    def clone(self):
        return self.__class__(self.ctxtf.getvalue())
        
    def set_register(self, reg):
        regstr = reg.asElf()

        self.ctxtf.seek(self.reg_offset)
        self.ctxtf.write(regstr)

    def get_register(self):
        self.ctxtf.seek(self.reg_offset)
        regstr = self.ctxtf.read(self.reg_size)
        self.register.fromElf(regstr)
        return self.register

class ElfPrstatus_x86_32(BaseElfPrstatus):
    def __init__(self, context=None):
        self.ctxt_size = 0x90
        self.reg_offset = 72
        self.reg_size = 68
        self.register = Register.Register('x86_32')

        BaseElfPrstatus.__init__(self, context)

        
class ElfPrstatus_x86_64(BaseElfPrstatus):
    def __init__(self, context=None):
        self.ctxt_size = 336
        self.reg_offset = 112
        self.reg_size = 216
        self.register = Register.Register('x86_64')

        BaseElfPrstatus.__init__(self, context)
        
arch = {'x86_32': ElfPrstatus_x86_32,
        'x86_32pae': ElfPrstatus_x86_32,
        'x86_64': ElfPrstatus_x86_64,
        # 'ppc': ElfPrstatus_PowerPC,
        }

def ElfPrstatus(archname, context=None):
    return arch[archname](context)
